// $Id: CCriticalSectionScope.cpp,v 1.4 2007/02/08 21:06:44 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CCriticalSectionScope.hpp"
using Exponent::Threading::CCriticalSectionScope;

//	===========================================================================
CCriticalSectionScope::CCriticalSectionScope(CCriticalSection &criticalSection) : m_entered(false), m_criticalSection(NULL)
{
	m_entered = false;
	NULL_POINTER(m_criticalSection);
	this->setAndEnterCriticalSection(&criticalSection);
}

//	===========================================================================
CCriticalSectionScope::CCriticalSectionScope(CCriticalSection *criticalSection) : m_entered(false), m_criticalSection(NULL)
{
	m_entered = false;
	NULL_POINTER(m_criticalSection);
	this->setAndEnterCriticalSection(criticalSection);
}

//	===========================================================================
CCriticalSectionScope::CCriticalSectionScope(CCriticalSection &criticalSection, const long waitTimeInMilliseconds) : m_entered(false), m_criticalSection(NULL)
{
	m_entered = false;
	NULL_POINTER(m_criticalSection);
	this->setAndTryToEnterCriticalSection(&criticalSection, waitTimeInMilliseconds);
}

//	===========================================================================
CCriticalSectionScope::CCriticalSectionScope(CCriticalSection *criticalSection, const long waitTimeInMilliseconds) : m_entered(false), m_criticalSection(NULL)
{
	m_entered = false;
	NULL_POINTER(m_criticalSection);
	this->setAndTryToEnterCriticalSection(criticalSection, waitTimeInMilliseconds);
}

//	===========================================================================
CCriticalSectionScope::~CCriticalSectionScope()
{
	this->endCriticalSection();
	FORGET_COUNTED_OBJECT(m_criticalSection);
}

//	===========================================================================
void CCriticalSectionScope::setAndEnterCriticalSection(CCriticalSection *criticalSection)
{
	// If we have a critical section currently, we want to exit it
	if (m_criticalSection)
	{
		this->endCriticalSection();
		FORGET_COUNTED_OBJECT(m_criticalSection);
	}

	// Store the ciritical section
	m_criticalSection = criticalSection;

	// If we have a criticalSection
	if (m_criticalSection)
	{
		// Referenced
		m_criticalSection->referenced();

		// Enter the critical section
		m_criticalSection->enterCriticalSection();

		// We have entered!
		m_entered = true;
	}
}

//	===========================================================================
bool CCriticalSectionScope::setAndTryToEnterCriticalSection(CCriticalSection *criticalSection, const long waitTimeInMilliseconds)
{
	// If we have a critical section currently, we want to exit it
	if (m_criticalSection)
	{
		this->endCriticalSection();
		FORGET_COUNTED_OBJECT(m_criticalSection);
	}

	// Store the ciritical section
	m_criticalSection = criticalSection;

	// If we have a criticalSection
	if (m_criticalSection)
	{
		// Referenced
		m_criticalSection->referenced();

		// Try and enter
		m_entered = m_criticalSection->tryToEnterCriticalSection(waitTimeInMilliseconds);
	}
	return m_entered;
}

//	===========================================================================
void CCriticalSectionScope::endCriticalSection()
{
	// If we have a critical section
	if (m_criticalSection && m_entered)
	{
		// Then we leave the section
		m_criticalSection->leaveCriticalSection();
		m_entered = false;
	}
}